//
// Multi Joint.js
//
// required version : Cheetah3D v.6.1
//
//  (c) 2012 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
//  2012-11-02 created.
// 
// Usage: Place this into ~/Library/Application Support/Cheetah3D/Scripts/Tool folder. restart Cheetah3D, then select from Tools -> Script -> Tool Script
//

function buildUI(tool) {
    tool.addParameterSeparator("Multi Joint");
    
    tool.addParameterBool('set type', 1, 0, 1, false, false);
    tool.addParameterSelector('joint type', ['JOINT_TYPE_ROOT', 'JOINT_TYPE_NORMAL'], false);
    
    tool.addParameterBool('set mode', 1, 0, 1, false, false);
    tool.addParameterSelector('joint mode', ['JOINT_DISPLAYMODE_LINE', 'JOINT_DISPLAYMODE_DIAMOND'], false);
    
    tool.addParameterBool('set color', 1, 0, 1, false, false);
    tool.addParameterFloat('joint color R', 1, 0, 1, false, false);
    tool.addParameterFloat('joint color G', 1, 0, 1, false, false);
    tool.addParameterFloat('joint color B', 1, 0, 1, false, false);
    tool.addParameterFloat('joint color A', 1, 0, 1, false, false);
    
    tool.addParameterBool("recursive",1,0,1,false,false);
    tool.addParameterBool("only children",1,0,1,false,false);
    
    tool.addParameterButton("apply","OK","apply");

    tool.addParameterSeparator("Capture Parameter");
    tool.addParameterButton("capture","capture","capture");
    
}

function capture(tool) {
    var doc = tool.document();
    var obj = doc.selectedObject();
    
    if (obj.type() == 45) {
      tool.setParameter("joint type", obj.getParameter("jointType"));
      tool.setParameter("joint mode", obj.getParameter("displayMode"));
      
      var color = obj.getParameter("jointColor");
      tool.setParameter("joint color R", color.x);
      tool.setParameter("joint color G", color.y);
      tool.setParameter("joint color B", color.z);
      tool.setParameter("joint color A", color.w);
    }
}

function apply(tool) {
    var doc = tool.document();
    var obj = doc.selectedObject();

    //print('---- Multi Bone ----');
    
    // setting param.
    setParamsWithTool(obj,tool,tool.getParameter("recursive"),tool.getParameter("only children"));
}


function setParamsWithTool(obj,tool,recursive,childrenOnly) {

    if (recursive) {
        if (obj.childCount() > 0) {
            var childCount = obj.childCount();
            for (var i = 0;i < childCount;i++) {
                var child = obj.childAtIndex(i);
                setParamsWithTool(child,tool,recursive,false);
            }
        }
    }
    
    if (childrenOnly == false && obj.type() == 45) {
        if (tool.parameterWithName) obj.recordParametersForUndo(); // for Undo
        
        if (tool.getParameter("set type")) obj.setParameter("jointType", tool.getParameter("joint type"));
        if (tool.getParameter("set mode")) obj.setParameter("displayMode", tool.getParameter("joint mode"));
        
        if (tool.getParameter("set color")) {
          var col = new Vec4D( tool.getParameter("joint color R"), tool.getParameter("joint color G"), tool.getParameter("joint color B"), tool.getParameter("joint color A") );
          obj.setParameter("jointColor", col);
        }
    }
}

// debug function.
function printVec3D(vec) {
    print('x:y:z-'+vec.x+':'+vec.y+':'+vec.z);
}
function printVec4D(vec) {
    print('r:g:b:a-'+vec.r+':'+vec.g+':'+vec.b+':'+vec.a);
}
function printMatrix(matrix) {
    print(matrix.m00+':'+matrix.m01+':'+matrix.m02+':'+matrix.m03);
    print(matrix.m10+':'+matrix.m11+':'+matrix.m12+':'+matrix.m13);
    print(matrix.m20+':'+matrix.m21+':'+matrix.m22+':'+matrix.m23);
    print(matrix.m30+':'+matrix.m31+':'+matrix.m32+':'+matrix.m33);    
}

